<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brian Doherty Portfolio</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("header.php"); ?>

	<main>
		<div class="container">
			<section>
				<div class="bd_into">
					<h2 class="h1">Hi I'm Brian</h2>

					<p class="p_large">I’m a UX/UI Designer with 8 years experience working in B2C e-commerce & B2B software development.</p>

					<p class="p_large">I’m passionate about creating experiences that help deliver business goals and meet customer expectations.</p>
				</div>
			</section>

			<section>
				<div class="bd_section_title">
					<h2>My Work</h2>

					<p class="p_large">A selection of works I have contributed to.</p>
				</div>
				
				<ul class="bd_projects_list">
					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-digital-rebrand.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<source type="image/webp" srcset="/images/arnotts-digital-rebrand-banner-640w.webp">

				        		<source srcset="/images/arnotts-digital-rebrand-banner-640w.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-digital-rebrand-banner-640w.jpg" alt="Arnotts Digital Rebrand" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts | Digital Rebrand</h3>

									<p class="p_bold">And a human, working within fast paced environments of the</p>
								</div>
							</div>
						</a>
					</li>


					<li class="bd_project">
						<a class="lazyload bd_project_image_block" href="/mywork/brown-thomas-redesign.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<source type="image/webp" data-srcset="/images/bt-design-system-banner-640w.webp">

				        		<source data-srcset="/images/bt-design-system-banner-640w.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img data-src="/images/bt-design-system-banner-640w.jpg" alt="" title="" class="lazyload bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Brown Thomas | Design System</h3>

									<p class="p_bold">Unifying the visual language.</p>
								</div>
							</div>
						</a>
					</li>


					<li class="bd_project">
						<a class="lazyload bd_project_image_block" href="/mywork/brown-thomas-arnotts-pdp-design-discovery.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<source type="image/webp" data-srcset="/images/bta-pdp-banner-640w.webp">

				        		<source data-srcset="/images/bta-pdp-banner-640w.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img data-src="/images/bta-pdp-banner-640w.jpg" alt="" title="" class="lazyload bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Brown Thomas Arnotts | PDP Design Discovery</h3>

									<p class="p_bold">Elevating the product display.</p>
								</div>
							</div>
						</a>
					</li>


					<li class="bd_project">
						<a class="lazyload bd_project_image_block" href="/mywork/brown-thomas-arnotts-app-user-research.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<source type="image/webp" data-srcset="/images/bta-app-research-banner-640w.webp">

				        		<source data-srcset="/images/bta-app-research-banner-640w.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img data-src="/images/bta-app-research-banner-640w.jpg" alt="" title="" class="lazyload bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Brown Thomas Arnotts | App User Research</h3>

									<p class="p_bold">Understanding the expectations of the app customers.</p>
								</div>
							</div>
						</a>
					</li>
				</ul>

				<div class="bd_btn_block">
					<a class="btn" href="">See all my work</a>
				</div>
			</section>
		</div>
	</main>

	<?php include("footer.php"); ?>
</body>
</html>