<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Arnotts | App</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Arnotts | App</h1>

						<p class="p_large">Creating a department store in your hand.</p>

						<p class="bd_project_reading_time">Reaing time 3 minutes</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/arnotts-app-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/arnotts-app-banner-1280x425.webp">

                		<source srcset="/images/arnotts-app-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/arnotts-app-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/arnotts-app-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>Arnotts was going through a period of growth while also redefining it’s digital brand and only had a loyalty ‘Wonder Card’ app in the native landscape. To continue to meet the expectations of the customer a project was started to create an IOS and Android app for Arnotts.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-app-old-wonder-app.png" alt="Arnotts wonder card app screens" style="width:100%;height:auto;">
						<figcaption>Arnotts wonder card app</figcaption>
					</figure>	

					<p>We again partnered with our existing app development agency in Scotland and this allowed us to utilise the learnings gathered in launching the Brown Thomas app. Our aim was to deliver an app that was elevated beyond just being a loyalty app to the full shopping experience.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-app-2-1280x720.png" alt="Arnotts app" style="width:100%;height:auto;">
						<figcaption>Arnotts app</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>We had a blueprint project to follow on with the Brown Thomas app project and we were all familiar with the Salesforce Commerce Cloud API. Our first challenge was the tight timeline for delivery, the project kicked off in June 2019 and was to be launched in late September. Our second challenge was identifying the unique customisations applied to the storefront journeys and functionality which would need to be adapted and in some cases elevated where possible.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was the UX lead and as part of the digital rebranding exercises worked closely with our design agency partners to create a baseline visual style guide for the app development team to apply to the front-end layouts.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-app-styleguide.png" alt="Arnotts app style guide sample" style="width:100%;height:auto;">
						<figcaption>Arnotts app - style guide sample</figcaption>
					</figure>

					<p>Once applied, I was responsible for signing off on the front-end designs ensuring they met our rigorous standard of the brand and the expectations of the customer. It was also my responsibility to collaborate & approve user stories ensuring all functionality and journeys were captured.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-app-checkout-journey.png" alt="Arnotts app guest checkout user flow" style="width:100%;height:auto;">
						<figcaption>Arnotts app - guest checkout user flow</figcaption>
					</figure>

					<p>Over the course of the project, we also held a working review group with stakeholders to update on project progress. I was also responsible for creating a number of onboarding decks to circulate with key brands to attain their permission to be included in the app offerings.</p>

					<div class="bd_iframe_container">
						<iframe src="https://docs.google.com/presentation/d/e/2PACX-1vQXohEVTW0Ltz5o0E49SqHew0GELj5RFMK4ZnlJhJfxa9Vqfb4nV_d8w0OR6plij0hdGGXDUOFQdGYR/embed?start=false&loop=true&delayms=60000" frameborder="0" width="960" height="569" allowfullscreen="true" mozallowfullscreen="true" webkitallowfullscreen="true" class="bd_responsive_iframe"></iframe>
					</div>

					<p>When timelines became tight and the launch date loomed, the full team came together and ensured QA was completed and the app was launched.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>We have been tracking approximately 35% higher conversion rate and 28% higher AOV than the mobile website experience. This has seen the app surpass all initial targets and expectations in the initial launch period. Currently tracking at 4.8 out of 5 on the App Store and at 2.7 out of 5 on the Play Store.</p>

					<a href="https://apps.apple.com/ie/app/arnotts/id906646085" class="link">Download the iOS app  →</a>

					<a href="https://play.google.com/store/apps/details?id=com.arnotts.loyaltyapp&hl=en_IE&gl=US" class="link">Download the Android app  →</a>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-app-store-preview" alt="Arnotts app in the Apple App Store" style="width:100%;height:auto;">
						<figcaption>Arnotts app in the Apple App Store</figcaption>
					</figure>	
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>This project allowed me to experience and practice aspects of product management over product design tasks, collaborating closely with internal and external stakeholders to fulfil business and customer needs. It also gave me a deep understanding of the unique experiences within the Arnotts customer journey and how they translate across the various channels.</p>
				</div>
		    </section>
		</div>

		<div class="container">
			<section class="bd_mywork">
				<div class="bd_section_title">
					<h2>Related to this project</h2>
				</div>
				
				<ul class="bd_projects_list">
					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-design-system.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-ds-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-ds-banner-1280x720.png" alt="" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: Design System</h3>

									<p class="p_bold">Creating a single source of truth.</p>
								</div>
							</div>
						</a>
					</li>

					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-digital-rebrand.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-digital-rebrand-banner-1280x720.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-digital-rebrand-banner-1280x720.jpg" alt="Arnotts Digital Rebrand" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: Digital Rebrand</h3>

									<p class="p_bold">And a human, working within fast paced environments of the</p>
								</div>
							</div>
						</a>
					</li>
				</ul>

				<div class="bd_btn_block">
					<a class="btn" href="/mywork/">See all my work</a>
				</div>
			</section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>