<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Arnotts | Design System</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Arnotts | Design System</h1>

						<p class="p_large">Creating a single source of truth.</p>

						<p class="bd_project_reading_time">Reading time 3 minutes</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/arnotts-ds-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/arnotts-ds-banner-1280x425.webp">

                		<source srcset="/images/arnotts-ds-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/arnotts-ds-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/arnotts-ds-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>As part of the Arnotts Digital Rebrand initiative in 2019, it was decided that a design system would be created. The goal of the design system was to unify the visual language by bringing consistency and efficiencies as the brands digital footprint scales.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-1-1280x720.jpg" alt="Arnotts brand work" style="width:100%;height:auto;">
						<figcaption>Arnotts brand work</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>Having run a number of workshops and analysed customer research, we needed to create a system that captured key findings while also addressing the updated brand image. This allowed us to set boundaries on the scope which had previously been an issue within the Brown Thomas design system project.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-atoms.png" alt="Arnotts design system elements" style="width:100%;height:auto;">
						<figcaption>Arnotts design system elements</figcaption>
					</figure>

					<p>We partnered with the design agency, Onstate, who are based in Leeds, England. The timelines were tight and we also had to jump start core component design due to the Arnotts app project running in parallel.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-app-styleguide.png" alt="Arnotts app style guide sample" style="width:100%;height:auto;">
						<figcaption>Arnotts app - style guide sample</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was the UX lead as part of the wider project for the digital rebrand and collaborated internally with a Project Manager & Business Analyst and externally with our design agency partner Onstate.</p>

					<p>It was my role to oversee the creation of the system, providing wireframes and guidance on the Arnotts SFCC platform capabilities, ensuring the design system addressed the needs of the business and customer.</p>

					<p>During key moments of the project timeline, I presented to an audience of stakeholders and business leaders on work in progress and communicated any key decisions that needed to be made and would require stakeholder input. I also lead the final presentation to the executive team in Brown Thomas Arnotts.
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>We delivered the final design system in September 2019, 4 weeks to spare and under budget. We were able to do this by using efficiencies gained from the structure of the Brown Thomas design system where we were able to quickly iterate to create a unique outcome for Arnotts.</p>

					<p>We were successful in creating a look & feel which elevated the brand and introduces some key creative and usability improvements such as:</p>

					<ul>
						<li>Extended product names</li>
						<li>Usability enhancements for product filters</li>
						<li>Image led navigation</li>
						<li>New visual devices</li>
						<li>Editorial/lifestyle look & feel</li>
					</ul>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-1.png" alt="Arnotts website look and feel examples" style="width:100%;height:auto;">
						<figcaption>Arnotts website look and feel examples</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-2.png" alt="Arnotts website look and feel examples" style="width:100%;height:auto;">
						<figcaption>Arnotts website look and feel examples</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-3.png" alt="Arnotts website look and feel examples" style="width:100%;height:auto;">
						<figcaption>Arnotts website look and feel examples</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-4.png" alt="Arnotts homepage" style="width:100%;height:auto;">
						<figcaption>Arnotts homepage desktop examples</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-5.png" alt="Arnotts homepage" style="width:100%;height:auto;">
						<figcaption>Arnotts homepage mobile example</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-6.png" alt="Arnotts homepage" style="width:100%;height:auto;">
						<figcaption>Arnotts homepage desktop example 2 & product list page with longer itm names</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-ds-look-feel-7.png" alt="Arnotts homepage" style="width:100%;height:auto;">
						<figcaption>Arnotts homepage, product filtering & product display page mobile</figcaption>
					</figure>

					<p>Once the system was signed off, the internal team set about planning the development of the new system into the Salesforce Commerce Cloud platform. It was decided to plan to initial sprints:</p>

					<h5>Sprint 1 - Brand alignment (font, icons, colours) (released Jan 2020)</h5>
					
					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-p1.jpg" alt="Arnotts website elements" style="width:100%;height:auto;">
						<figcaption>Arnotts website rebranding - font, colours & icons</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-p1-1.jpg" alt="Arnotts website product elements" style="width:100%;height:auto;">
						<figcaption>Arnotts website rebranding - product display</figcaption>
					</figure>

					<h5>Sprint 2 - Filtering & Search enhancements (released Feb 2020)</h5>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-p2-2.png" alt="Arnotts website product elements" style="width:100%;height:auto;">
						<figcaption>Arnotts website rebranding - product filtering mobile view</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-p2-3.png" alt="Arnotts website product elements" style="width:100%;height:auto;">
						<figcaption>Arnotts website rebranding - product search suggestions</figcaption>
					</figure>
					
					<p>Due to the start of the pandemic, all further plans to further integrate the design system were shelved.</p>

					<a href="https://www.arnotts.ie" class="link">Visit the arnotts.ie →</a>

					<a href="https://invis.io/FBU2IQNJKS5" class="link">View the documentation →</a>
				</div>

				<figure class="bd_project_large_img">
					<img class="lazyload" data-src="/images/arnotts-digital-rebrand-result.jpg" alt="Arnotts app and website" style="width:100%;height:auto;">
					<figcaption>Arnotts website rebranding - app homescreen & website product listing</figcaption>
				</figure>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>In this project I was again able to develop my working relationship with stakeholders throughout the organisation and while also maintaining close relationships with our design & development partners.</p>

					<p>It was also my second time involved in creating a design system and in the project I felt a lot more comfortable and in control of myself. The learnings and failings during previous projects allowed us to be very concise with our requirements and clear in our communications. We set clear boundaries regarding the scope which allowed us to focus on the key deliverables.</p>

					<p>Unfortunately this was another project that did not see the full light of day though.</p>
				</div>
		    </section>
		</div>

		<div class="container">
			<section class="bd_mywork">
				<div class="bd_section_title">
					<h2>Related to this project</h2>
				</div>
				
				<ul class="bd_projects_list">
					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-app.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-app-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-app-banner-1280x720.png" alt="Arnotts App" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts | App</h3>

									<p class="p_bold">Creating a department store in your hand.</p>
								</div>
							</div>
						</a>
					</li>

					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-digital-rebrand.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-digital-rebrand-banner-1280x720.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-digital-rebrand-banner-1280x720.jpg" alt="Arnotts Digital Rebrand" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts | Digital Rebrand</h3>

									<p class="p_bold">And a human, working within fast paced environments of the</p>
								</div>
							</div>
						</a>
					</li>

					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/brown-thomas-arnotts-pdp-design-discovery.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!-- <source type="image/webp" srcset="https://via.placeholder.com/640x360.webp"> -->

				        		<source srcset="/images/bta-pdp-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/bta-pdp-banner-1280x720.png" alt="" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Brown Thomas Arnotts | PDP Design Discovery</h3>

									<p class="p_bold">Elevating the product display.</p>
								</div>
							</div>
						</a>
					</li>
				</ul>

				<div class="bd_btn_block">
					<a class="btn" href="/mywork/">See all my work</a>
				</div>
			</section>
		</div>
	</main>


	<?php include("../footer.php"); ?>
</body>
</html>