<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Arnotts | Digital Rebrand</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Arnotts | Digital Rebrand</h1>

						<p class="p_large">Developing a new look & feel for the department store.</p>

						<p class="bd_project_reading_time">Reading time 5 minutes</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/arnotts-digital-rebrand-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/arnotts-digital-rebrand-banner-1280x425.webp">

                		<source srcset="/images/arnotts-digital-rebrand-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/arnotts-digital-rebrand-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/arnotts-digital-rebrand-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>In 2018, Arnotts began a process of reevaluating their brand identity. An external design agency was brought in to develop a clear, ownable and exciting brand world for Arnotts creating a clear direction for all brand activity.</p>

					<p>Deliverables included:</p>

					<ul>
						<li>New logo</li>
						<li>New Shopping bag</li>
						<li>New Brand colours, typography & unified visual direction</li>
						<li>Customer Personas</li>
						<li>Tone of Voice</li>
					</ul>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-1-1280x720.jpg" alt="Arnotts brand work" style="width:100%;height:auto;">
						<figcaption>Arnotts brand work</figcaption>
					</figure>	
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>Our task was to translate the brand work, which had a heavy lean to more traditional advertising, and incorporate this into the Arnotts digital products. The project had a number of deliverables phased over a 6 month period and we would work with a design agency to assist in delivering across the projects.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-2-timelines.png" alt="Arnotts rebrand project timelines" style="width:100%;height:auto;">
						<figcaption>Project timelines</figcaption>
					</figure>

					<ul>
						<li>Arnotts Checkout Redesign (Aug 2019)</li>

						<li>Arnotts Visual Design System (Sept 2019)
							<ul>
								<li>Atomic based visual design library</li>
								<li>New content types</li>
								<li>Component Prototypes</li>
							</ul>
						</li>
						
						<li>Arnotts iOS/Android App (Oct 2019)
							<ul>
								<li>Approve and create user stories for development</li>
								<li>Create style guide and approve design in collaboration with the App agency</li>
							</ul>
						</li>

						<li>Arnotts ecommerce website rebrand (2020)
							<ul>
								<li>Implement brand elements of the visual design system</li>
								<li>Enhance product discovery journey</li>
							</ul>
						</li>
					</ul>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was the UX lead on the internal Arnotts team which had 2 Project Managers, a Business Analyst and a Technical Analyst. Externally we collaborated with our partner design agency, Onstate, to deliver on the digital brand & design system. While for the app, we worked closely with our existing development agency for the Brown Thomas app, NN4M.</p>

					<h5>Discovery</h5>

					<p>During the initial discovery phase, I contributed to the internal research effort using stakeholder surveys & discovery workshop sessions. The goal of these surveys & sessions was to better understand how and what changes might be needed to help them achieve their business goals. I wrote the survey and through this, in collaboration with Onstate, were able to gather key themes to focus on in the workshops, which we would hold over 2 days in early July 2019.</p>

					<figure>
						<img class="lazyload" data-src="/images/arn-workshop_June_2019.jpg" alt="peple attending a workshop" style="width:100%;height:auto;">
						<figcaption>Arnotts discovery workshop - June 2019</figcaption>
					</figure>	

					<h5>Design System</h5>

					<p>Having completed the Brown Thomas Design System earlier in the year, we knew the structure we wanted to follow. Working alongside the team at Onstate, we worked to develop & enhance the user flows and design patterns highlighted in research and known to the team.</p>


					<p>During the course of the project I was responsible for sign off with the agency, ensuring standards and requirements were upheld while also providing wireframes to fill any gaps. I also presented to stakeholders at key project moments and led the final presentation to the executive team in Brown Thomas Arnotts.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-ds-1280x720.png" alt="Arnotts design system" style="width:100%;height:auto;">
						<figcaption>Arnotts design system elements</figcaption>
					</figure>	

					<a href="arnotts-design-system.php" class="link">Read more about this project here →</a>

					<h5>iOS/Android App</h5>

					<p>I worked closely with our design agency partners to create a baseline visual style guide for the app development team to apply to the front-end layouts.</p>

					<p>Once applied, I was responsible for signing off on the front-end designs ensuring they achieved the high standard the business desired. It was also my responsibility to collaborate & approve user stories ensuring all functionality and journeys were captured.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-app-2-1280x720.png" alt="Arnotts app" style="width:100%;height:auto;">
						<figcaption>Arnotts app</figcaption>
					</figure>

					<a href="arnotts-app.php" class="link">Read more about this project here →</a>

					<h5>Ecommerce Website</h5>

					<p>Once the visual design system had been approved by the executive team, we gathered together and began to plan the implementation with our Salesforce Commerce Cloud development team. Grouping tasks into sprints, the goal of sprint 1 was to bring brand alignment between the website and the app.</p>

					<p>This involved introducing the new brand font, new brand colours and new iconography. Due to the large number of dependencies when updating the font, it was my responsibility to map the correct weights and sizes into tickets, working closely with our Business Analyst, QA and external Front-End Developer to ensure exact detail was available.</p>

					<p>The second sprint focused on the customer journey through the shopping funnel - primarily filtering and UI enhancements on product listing pages. I created all high fidelity wireframes and collaborated with developers and QA to deliver on the sprint goals.</p>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-p1.jpg" alt="Arnotts website elements" style="width:100%;height:auto;">
						<figcaption>Arnotts website rebranding - font, colours & icons</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/arnotts-digital-rebrand-p1-1.jpg" alt="Arnotts website product elements" style="width:100%;height:auto;">
						<figcaption>Arnotts website rebranding - product display</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>The primary result of this large scale project was a unified visual language across the website, app & in store communications. The design system introduced a shared set of principles allowing a consistent experience across the different touch points while also allowing us to scale and build new features quickly and efficiently.</p>

					<p>The launch of the Arnotts App saw increased engagement with a higher conversion rate and AOV when compared to the website. The brand refresh and functional updates to the website, gave the user a more intuitive and streamlined product search and filtering functionality, along with some image & performance enhancements, all these changes contributed to an increase in conversion.</p>

					<a href="https://arnotts.ie" class="link">Visit the website →</a>

					<a href="https://apps.apple.com/ie/app/arnotts/id906646085" class="link">Download the iOS app  →</a>

					<a href="https://play.google.com/store/apps/details?id=com.arnotts.loyaltyapp&hl=en_IE&gl=US" class="link">Download the Android app  →</a>
				</div>

				<figure class="bd_project_large_img">
					<img class="lazyload" data-src="/images/arnotts-digital-rebrand-result.jpg" alt="Arnotts app and website" style="width:100%;height:auto;">
					<figcaption>Arnotts website rebranding - app homescreen & website product listing</figcaption>
				</figure>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>This project gave me experience being involved in large scale organisational effort in bringing a consistent visual language to so many products and touch points.</p>

					<p>It allowed me to work closely with numerous departments, stakeholders and agencies and gave me experience in balancing timelines & communications across the various streams. Learnings from previous projects were applied regarding stakeholder feedback loops - we decided to involve and communicate at key moments in the timeline rather than a constant loop which previously caused iterations and scope to become unwieldy.</p>

					<p>It was a challenging 8 months and I certainly felt the weight of it all having been so involved in the process from initial discovery to product launches. The cadence of project and deliverables was not ideal and some pivots in the final design system were decided upon too late to retrospectively apply to the app that launched as the system was finalised.</p>
				</div>
		    </section>
		</div>

		

		<div class="container">
			<section class="bd_mywork">
				<div class="bd_section_title">
					<h2>Related to this project</h2>
				</div>
				
				<ul class="bd_projects_list">
					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-design-system.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-ds-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-ds-banner-1280x720.png" alt="" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: Design System</h3>

									<p class="p_bold">Creating a single source of truth.</p>
								</div>
							</div>
						</a>
					</li>

					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-app.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-app-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-app-banner-1280x720.png" alt="Arnotts App" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: App</h3>

									<p class="p_bold">Creating a department store in your hand.</p>
								</div>
							</div>
						</a>
					</li>
				</ul>

				<div class="bd_btn_block">
					<a class="btn" href="/mywork/">See all my work</a>
				</div>
			</section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>