<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brown Thomas | App Checkout</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Brown Thomas | App Checkout</h1>

						<p class="p_large">Building a native app checkout experience.</p>

						<p class="bd_project_reading_time">Reading time 2 minutes, 30 seconds</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/bt-app-checkout-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/bt-app-checkout-banner-1280x425.webp">

                		<source srcset="/images/bt-app-checkout-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/bt-app-checkout-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/bt-app-checkout-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>In 2017, Brown Thomas was in a period of online growth and embarked on a project to update their existing loyalty app to a fully shoppable platform with the loyalty program deeply integrated. Partnering with development agency NN4M in Scotland, the goal of the project was to create a fully transactional app for iOS & Android.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-app-checkout-old-app.png" alt="Brown Thomas Loyalty app screens" style="width:100%;height:auto;">
						<figcaption>Screenshots of the old Brown Thomas Loyalty app for iOS</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>Brown Thomas is configured on top of the Salesforce Commerce Cloud platform, which has an extensive API available. As an omnichannel business, there were extensive customisations to facilitate unique business operations.</p>

					<p>With specific regard to the checkout, these included:</p>

					<ul>
						<li>Delivery to multiple addresses</li>
						<li>Gift Card redemption</li>
						<li>Loyalty points - earn or redeem</li>
						<li>Gift Wrapping</li>
					</ul>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>Initially I was to cover the paternity leave of my colleague and the UX lead on the project, working with the designer at NN4M to create and capture the front-end design requirements. When complications arose during the ideation of the checkout flow, I was tasked with defining and visualising the checkout journey due to my experience & knowledge gained when designing the Brown Thomas website checkout.</p>

					<p>I decided a medium fidelity prototype would cover what was required. I began by benchmarking market leaders applications, learning the subtle differences when designing for a website or an app and how each step was focused to a single action.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-app-checkout-prototype.png" alt="Prototype flow diagram" style="width:100%;height:auto;">
						<figcaption>Checkout prototype flow diagram</figcaption>
					</figure>

					<p>The prototype illustrated a simplified flow, with clear signposting and communication. It aligned the customer decision points with the website as close as possible, such as whether the order was a delivery, multiple address deliver or click & collect and having payment options grouped together in one screen.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-app-checkout-multiple-addresses-gift-warp.png" alt="Prototype flow diagram" style="width:100%;height:auto;">
						<figcaption>Checkout designs - multiple address delivery & gift wrap screens</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>On the launch of the Brown Thomas app, some more complex flows such as multiple address delivery had been descoped to allow an already delayed deadline to be met. The app conversion rate was tracking approximately 30% higher than the mobile website experience. The app is currently tracking at 4.8 out of 5 on the App Store and 4.1 out of 5 in the Play Store.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-app-checkout-app-store.png" alt="Brown Thomas app - App Store" style="width:100%;height:auto;">
						<figcaption>Brown Thomas app - App Store</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bt-app-checkout-play-store.png" alt="Brown Thomas app - Play Store" style="width:100%;height:auto;">
						<figcaption>Brown Thomas app - Play Store</figcaption>
					</figure>

					<a href="https://apps.apple.com/ie/app/brown-thomas/id919501446" class="link">Download the iOS app  →</a>

					<a href="https://play.google.com/store/apps/details?id=com.furioustribe.brownThomas&hl=en_IE&gl=US" class="link">Download the Android app  →</a>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>This was my first experience designing for a native application and I was able to develop my understanding of the conventions of each platform. It was also my first time experiencing aspects of product management allowing me to learn and develop while collaborating with colleagues internally and externally.</p>

					<p>Being able to leverage previous work on the Brown Thomas website checkout, I was able to identify the gaps in knowledge with external colleagues. The need for a simple prototype to show the flow of the customer through the checkout journey aided in communicating the complexities and customisations contained within the system.</p>
				</div>
		    </section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>