<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brian Doherty Portfolio</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Brown Thomas Arnotts | App User Research</h1>

						<p class="p_large">Understanding the expectations of the app customer.</p>

						<p class="bd_project_reading_time">Reading time 3 minutes</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/bta-app-research-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/bta-app-research-banner-1280x425.webp">

                		<source srcset="/images/bta-app-research-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/bta-app-research-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/bta-app-research-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>Since their launch, the iOS & Android apps for both brands have been hugely successful especially with a large adoption of the native applications by the brand's highly engaged customer base. With the intention of making enhancements to the apps, we wanted to better understand the goals and expectations of the customer when shopping on their phone.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>To create a short survey and target potential participants using a direct app push message with email used if engagement is low.</p>

					<p>In this survey we aimed to avoid certain types of questions, which required a shift in mindset by the business.</p>

					<ul>
						<li>Asking the respondent to predict future actions</li>
						<li>Asking the respondent to validate potential features, roadmaps etc.</li>
					</ul>

					<figure>
						<img class="lazyload" data-src="/images/bta-app-research-push-messages.png" alt="App survey push notification" style="width:100%;height:auto;">
						<figcaption>App survey push notification</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was appointed by the Head of Product to lead the UX research initiative alongside 2 senior  members of the CRM team. As part of the role, I wrote the survey questions, settling on 2 separate types of customer - those that have used the app to purchase something and those that have not.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-app-research-questions.png" alt="App survey questions sample" style="width:100%;height:auto;">
						<figcaption>App survey questions sample</figcaption>
					</figure>

					<p>It was my aim to create a short & simple survey, with careful use of question types so that open ended questions were used in key moments. The intent of each question was also aimed at actions and recollections of experiences using the Brown Thomas | Arnotts apps along with other apps the respondent has used on their phone.</p>

					<p>I was also responsible for analysing responses and contributing to the production of an internal report to enforce the app enhancement agenda.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>The Brown Thomas push notification generated almost 3,500 survey responses over a 3 day period. However the Arnotts push had a lower engagement, at almost 800 survey responses so a retargeting using email was sent to the customer base generating a further 2,400 responses, 3,200 in total.</p>

					<p>Satisfied with the volume of respondents, we set about analysing the data we had gathered, separating demographic & sentiment metrics from qualitative responses gathered through open ended questions. It was through these we were able to create basic categories or themes to group responses together while also being able to align these responses with the customer journey in the app.</p>

					<p>A report was created and to be presented to key stakeholders to enhance the apps for both brands so that they can equal and hopefully surpass the customers expectations. The surveys have also identified some key areas which can be explored in greater detail using follow up surveys and user interviews.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-app-research-results.png" alt="App survey results sample" style="width:100%;height:auto;">
						<figcaption>App survey results sample</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>This initiative allowed me to work closely with my colleagues on the CRM team. This approach to a survey was a leap for them, one which they embraced and their contribution in identifying the push notification as a targeting method really helped capture highly engaged respondents.</p>

					<p>I was given the freedom to create the questions for the survey which allowed me to focus deeply on how best to trigger a sense of recollection of experiences in their responses. I learned how to thread a dual line of questioning and the complexities it can bring.</p>

					<p>Regarding the survey results, some interesting observations can be made, one being that customers like to browse on the app but finish the purchase journey on their laptop/desktop. Reasoning given centered around the product imagery on their phone screen not being big enough to validate their decision to purchase.</p>
				</div>
		    </section>

		    <section class="bd_mywork">
				<div class="bd_btn_block">
					<a class="btn" href="/mywork/">See all my work</a>
				</div>
			</section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>