<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brown Thomas Arnotts | Cookie Compliance</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Brown Thomas Arnotts | Cookie Compliance</h1>

						<p class="p_large">Integrating the OneTrust cookie manager.</p>

						<p class="bd_project_reading_time">Reading time 2 minutes, 30 seconds</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/bta-cookies-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/bta-cookies-banner-1280x425.webp">

                		<source srcset="/images/bta-cookies-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/bta-cookies-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/bta-cookies-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>As part of EU legislation, there is a legal obligation to give website visitors a choice to consent or not to the use of cookies, excluding necessary cookies, on the brownthomas.com & arnotts.ie websites.</p>

					<p>In the Brown Thomas & Arnotts Salesforce Commerce Cloud platforms, cookie consent management is restricted. In order to comply and inform visitors of any data collection (via ‘non-necessary’ cookies) on the websites, we integrated with OneTrust to manage cookie consent and provide visitors with transparency and control of the cookies & tracking technologies used.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>If no action is taken, the business would be breaching the ‘Cookies’ Directive which would place the overall Selfridges group at significant risk of fines and brand impact. This integration had to be complete by no later than the 5th October 2020.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>As the front-end specialist on the team, my role was to see this project through from start to finish. This involved gathering a deep understanding of technical integration of the cookie consent banner while collaborating closely with OneTrust, the internal DPO (Data Protection Officer) and the analytics team to communicate the implications for the existing vendors and integrations on both websites.</p>

					<p>In collaboration with internal teams & third party integrators, we set about categorising the cookies discovered as the result of a full website scan using the OneTrust tool.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-cookies-classification.png" alt="Cookie categorisation list" style="width:100%;height:auto;">
						<figcaption>Cookie categorisation list</figcaption>
					</figure>

					<p>Once that task was complete, we were able to begin the process of updating the Google Tag Manager containers. I worked closely with the analytics team to update and amend all of the tags & triggers with the necessary logic to ensure compliance.</p>

					<p>I was also responsible for documenting the process for the business, creating a series of "How To" documents and running a number of hand over sessions with the team that were taking ownership of the integration.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>Both brownthomas.com (3rd September 2020) & arnotts.ie (28th September 2020) integrations were launched just prior to the specified date of the EU directive (5th October 2020). The integration was reviewed by an Irish Data Protection Commision representative in early October 2020 and passed as fully compliant.</p>

					<p>Both websites were now completely transparent and put the customer in control of the cookies & tracking technologies used.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-cookies-web-banners.png" alt="Cookie banner displayed on brownthomas.com and arnotts.ie" style="width:100%;height:auto;">
						<figcaption>Cookie banner displayed on brownthomas.com and arnotts.ie</figcaption>
					</figure>

					<a href="https://www.brownthomas.com" class="link">Visit the brownthomas.com →</a>

					<a href="https://www.arnotts.ie" class="link">Visit the arnotts.ie →</a>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>This project allowed me to blend aspects of project management & front-end development and gave me a deep understanding of the underlying structures of both websites while also giving a glimpse into the world of cookies and tracking technologies.</p>

					<p>An offshoot of integrating the OneTrust through GTM allowed for a large-scale evaluation of all the tags & triggers (and there were lots!) in each brand's tag manager container. Cutting and refining a large majority, we were actually able to enhance the average page load times for both websites with an average reduction of 1 second on each.</p>

					<p>Brownthomas.com has averaged between 3.2s - 3.8s page load speed while arnotts.ie averaged between 3.9s - 4.2s.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-cookies-site-speed.png" alt="brownthomas.com and arnotts.ie site speed data" style="width:100%;height:auto;">
						<figcaption>brownthomas.com and arnotts.ie site speed data (March 2020 - March 2021)</figcaption>
					</figure>
				</div>
		    </section>

		    <section class="bd_mywork">
				<div class="bd_btn_block">
					<a class="btn" href="/mywork/">See all my work</a>
				</div>
			</section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>