<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brown Thomas Arnotts | PDP Design Discovery</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Brown Thomas Arnotts | PDP Design Discovery</h1>

						<p class="p_large">Elevating the product display.</p>

						<p class="bd_project_reading_time">Reading time 4 minutes</p>
					</div>
					
					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/bta-pdp-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/bta-pdp-banner-1280x425.webp">

                		<source srcset="/images/bta-pdp-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/bta-pdp-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/bta-pdp-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>Both the Brown Thomas & Arnotts PDP (Product Detail Page) templates had remained stagnant, adhering to basic conventions regarding layout & design. In the summer of 2019, a project was initiated to examine how we could enhance the experience for customers when viewing product detail pages on any device.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-basic-display-old.png" alt="Arnott & Brown Thomas PDP" style="width:100%;height:auto;">
						<figcaption>Arnott & Brown Thomas PDP (2018)</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>The approach to this project has many dimensions. The PDP template is a sort of one-size fits all template and when applied to a department store store it must cater to customers ranging from beauty to fashions to homewares. There are also a number of other variations of the template which cater for bundles of products, set’s of products, collections of products and an enhanced template for high-end furniture in Arnotts.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-types.png" alt="Arnott & Brown Thomas - selection of available products" style="width:100%;height:auto;">
						<figcaption>Arnott & Brown Thomas - selection of available products</figcaption>
					</figure>

					<p>Ensuring our research was thorough was crucial and this involved understanding the process of the business users as well as the customer to avoid any unnecessary friction in the workflows.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was the lead designer and worked very closely with 2 colleagues, a project manager and a business analyst, to fulfil the request of the business. Together we created and actioned a strategy that had 3 phases of discovery that we felt would drive successful outcomes for the project.</p>

					<ol>
						<li>Custmer research & Benchmarking analysis</li>
						<li>Individual & Group Stakeholder Interviews</li>
						<li>Design</li>
					</ol>

					<p>My first task was to detail all the existing elements and components that make up the various templates per category. This allowed us to see common elements. We then set about the research & benchmarking tasks for which I conducted interviews with a number of senior stakeholders and key departmental heads to better understand their goals and how the template could be enhanced to help them achieve further goals.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-research-attributes.png" alt="Arnott & Brown Thomas - product page elements" style="width:100%;height:auto;">
						<figcaption>Arnott & Brown Thomas - product page elements</figcaption>
					</figure>

					<p>Once individual interviews were complete we brought all stakeholders together, along with other senior representatives from the various departments to discuss all the findings of the research, benchmarking & interviews to that date. With some clarity and consensus on what to focus on from this gathering, I finally began to create wireframes incorporating these alterations & updates to the PDP template.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-wireframes.png" alt="Arnott & Brown Thomas - Wireframes" style="width:100%;height:auto;">
						<figcaption>Arnott & Brown Thomas - Wireframes</figcaption>
					</figure>

					<p>Some of the key findings were:</p>

					<ol>
						<li>Size buttons as an option instead of dropdown menus.</li>
						<li>Enhanced colour pickers</li>
						<li>Stock indicators.</li>
						<li>Include more opportunities for additional information related to the product such as ingredients & buying guides for homewares</li>
						<li>Enhanced upsell opportunities</li>
						<li>Separation of key user action elements (price, selectors, buttons) from information specific elements to create a clean layout while utilising all available space</li>
					</ol>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-sizes-focus.png" alt="Size buttons as an options instead of dropdown menus" style="width:100%;height:auto;">
						<figcaption>1. Size buttons as an option instead of dropdown menus.</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-colour-picker.png" alt="Enhanced colour pickers" style="width:100%;height:auto;">
						<figcaption>2. Enhanced colour pickers.</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-stock-indicators.png" alt="Stock indicators" style="width:100%;height:auto;">
						<figcaption>3. Stock indicators.</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-buying-guides-ingredients.png" alt="additional information panels related to the product" style="width:100%;height:auto;">
						<figcaption>4. Include more opportunities for additional information related to the product such as ingredients & buying guides for homewares.</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-upsells.png" alt="Enhanced upsell opportunities" style="width:100%;height:auto;">
						<figcaption>5. Enhanced upsell opportunities - more recommendation carousels & outfit builders.</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-layout.png" alt="Separation of key user action elements" style="width:100%;height:auto;">
						<figcaption>6. Separation of key user action elements (price, selectors, buttons) from information specific elements to create a clean layout while utilising all available space.</figcaption>
					</figure>

					<p>I created a number of versions of the PDP, each tailored to a specific customer group - beauty, fashions and homewares. These 3 categories of PDP’s encapsulated the updates to the various components utilised across the majority of products available on the websites.</p>

					<p>As a core theme from stakeholders was also to be “mobile first”, I was able to leverage some inspiration and learning from the iOS & Android app development & design. In addition to redesigning components, I wanted to incorporate some performance optimisations especially regarding imagery and native gestures on touch devices.</p>

					<p>A number of feedback loops were opened with stakeholders before approval was given to the proposed changes. I then set about creating a working prototype using HTML, CSS & JS to capture the vision in a true form.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-pdp-product-final-designs-sample.png" alt="Arnott & Brown Thomas - Wireframes" style="width:100%;height:auto;">
						<figcaption>Arnott & Brown Thomas - sample of final designs proposed for Brown Thomas</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>In October of 2019, the Head of Product, the Multichannel Director and I presented the vision for the next stage of our PDP to the Managing Director of Brown Thomas | Arnotts as part of the wider Digital Rebrand project. Feedback was concise and ultimately the proposals were very well received with a limited number of amendments.</p>

					<p>Due to reasons out of our control, the plans to develop and implement the proposals were put on hold and have yet to be fully realised. Some elements were tested through a CRO program and were later integrated fully to the core functionality of the websites.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>This project, while ultimately not complete, allowed me to work closely with senior business leaders and to develop a deep knowledge of the different types of customer. Always empathetic to their needs and expectations.</p>

					<p>This project gave me another insight into the complexities of large scale redesigns. I learned to shape future work better, breaking alterations down to the smallest possible piece to maintain impact while lowering scope, but also learning when to push for extra to truly maximise impact.</p>
				</div>
		    </section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>