<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brown Thomas Arnotts | Product Image Optimisation</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Brown Thomas Arnotts | Product Image Optimisation</h1>

						<p class="p_large">Enhancing the clarity of product imagery.</p>

						<p class="bd_project_reading_time">Reading time 2 minutes, 30 seconds</p>
					</div>

					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/bta-product-image-optimisation-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/bta-product-image-optimisation-banner-1280x425.webp">

                		<source srcset="/images/bta-product-image-optimisation-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/bta-product-image-optimisation-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/bta-product-image-optimisation-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>Clear product imagery is so important to a customer when making a purchasing decision online. Still using a ‘one size fits all’ jpg image, in 2018 Brown Thomas Arnotts began a process to evaluate how we could leverage modern image technologies to display sharper and more accurate representation of the product.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>Enhancing the display of thousands of product images across both brownthomas.com & arnotts.ie while introducing modern image formats to optimise the images for clear representation and increased performance.</p>

					<p>While we have our own Enrichment team and photo studio to shoot imagery, we also work with a lot of concession brands that supply their own. This reduced the control we have on quality and weight specifications.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-product-image-optimisation-enrichment-flow.png" alt="Product images at differing sizes" style="width:100%;height:auto;">
						<figcaption>Enrichment of images supplied by concession brand needed to upload to the website</figcaption>
					</figure>

					<figure>
						<img class="lazyload" data-src="/images/bta-product-image-optimisation-enrichment-flow-2.png" alt="comparison of 2 images" style="width:100%;height:auto;">
						<figcaption>Raw image being used without optimisations increased in weight</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was responsible for the initial exploration regarding image formats & rendering optimisations that could be applied. I worked closely with our image DAM integration partners to understand the features available to use in their Dynamic Media platform.</p>

					<p>Once exploration was complete I created a number of picture tag templates which integrated new image formats WebP & JPEG2000 with a JPG as a fallback. Placing each new image tag side by side with the existing image tag in a live HTML prototype page, I then was able to show stakeholders the difference between and gain approval to push the changes through in the following sprint.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-product-image-optimisation-enrichment-flow-4.png" alt="2 images using different formats side by side" style="width:100%;height:auto;">
						<figcaption>Comparison of webp / jpeg side by side</figcaption>
					</figure>

					<p>I also provided documentation, examples and guidance to colleagues on other business teams to include in their own processes using imagery.</p>

					<figure>
						<img class="lazyload" data-src="/images/bta-product-image-optimisation-enrichment-flow-3.png" alt="guide for team when exporting from photoshop" style="width:100%;height:auto;">
						<figcaption>Some basic tips for the enrichment team when exporting images from Photoshop</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>The outcome of this update was distinctly clearer product imagery from product listing pages to product display pages to product carousels helping to reduce customer queries. The addition of modern image formats reduced the weight of each product image, ranging between 30% - 60% in some cases.</p>
				</div>

				<div class="bd_side_by_side_images">
					<div class="bd_side_by_side_image">
						<picture>
						    <!--[if IE 9]><video style="display: none;"><![endif]-->
						    <source type="image/webp" srcset="//images.brownthomas.com/i/brown_thomas/1400x502356xanastasialora_01?$product_tile_plp$&$webp$">

						    <source srcset="//images.brownthomas.com/i/brown_thomas/1400x502356xanastasialora_01?$product_tile_plp$&$jpg$">

						    <!--[if IE 9]></video><![endif]-->
						    <img src="//images.brownthomas.com/i/brown_thomas/1400x502356xanastasialora_01?$product_tile_plp$&$jpg$" alt="{{ content_name }}" title="" class="product-tile">
						</picture>
					</div>

					<div class="bd_side_by_side_image">
						<img src="//images.brownthomas.com/i/brown_thomas/1400x502356xanastasialora_01?w=330" alt="{{ content_name }}" title="" class="product-tile">
					</div>
				</div>

				<div class="bd_article_container">
					<a href="https://www.brownthomas.com/women/" class="link">Visit the brownthomas.com site to see live examples →</a>

					<a href="https://www.arnotts.ie/women/clothing/dresses/" class="link">Visit the arnotts.ie site to see live examples →</a>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>Customers expect product images to look exactly as the physical item so displaying these images on the storefront as clearly and in as much detail as possible is vitally important. This fact enabled me to push the agenda and I was able to bring multiple teams in the department together and show the impact this would achieve and gain consensus on the changes required.</p>

					<p>I also learned in depth how modern image formats, such as WebP, are the next level of media for the web allowing for higher resolution images without the massive weight that’s associated with formats such as PNG. Unfortunately these formats didn’t impact page load in any significant way but did so when combined with other performance tactics.</p>
				</div>
		    </section>
		</div>

		<div class="container">
			<section class="bd_mywork">
				<div class="bd_section_title">
					<h2>Related to this project</h2>
				</div>
				
				<ul class="bd_projects_list">
					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-design-system.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-ds-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-ds-banner-1280x720.png" alt="" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: Design System</h3>

									<p class="p_bold">Creating a single source of truth.</p>
								</div>
							</div>
						</a>
					</li>
				</ul>
			</section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>