<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title>Brown Thomas | Redesign</title>
	<meta name="author" content="Brian Doherty">
	<meta name="description" content="The portfolio of UX/UI Designer, Brian Doherty">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		
	</style>

	<link rel="stylesheet" href="/css/styles.css">
	<link rel="icon" type="image/png" href="/images/favicon.png">
</head>

<body>

	<?php include("../header.php"); ?>	

	<main>
		<div class="container bd_project_template">
		    <section>
		        <div class="bd_project_banner">
		        	<div class="bd_article_container">
						<h1 class="h1">Brown Thomas | Redesign</h1>

						<p class="p_large">Elevating the digital brand.</p>

						<p class="bd_project_reading_time">Reading time 3 minutes</p>
					</div>
					
					<picture>
						<!--[if IE 9]><video style="display: none;"><![endif]-->
						<source type="image/webp" srcset="/images/bt-design-system-banner-640w.webp" media="(max-width: 640px)">

                		<source type="image/webp" srcset="/images/bt-design-system-banner-1280x425.webp">

                		<source srcset="/images/bt-design-system-banner-640w.jpg" media="(max-width: 640px)">

                		<source srcset="/images/bt-design-system-banner-1280x425.jpg">

						<!--[if IE 9]></video><![endif]-->
                		<img src="/images/bt-design-system-banner-1280x425.jpg" alt="Arnotts Transactional App" title="" class="bd_project_banner_image">
					</picture>
				</div>
		    </section>
		    	
		    <section>
		        <div class="bd_article_container">
					<h2>Background</h2>

					<p>Brown Thomas had undertaken a number of projects in 2017 to review & update the brand purpose and tone of voice by launching a digital magazine and a revamped loyalty program. The outcome of this work was a new confidence and ability to leverage the authority of the brand in communications with the customer. The existing digital products did not reflect this and as such a “redesign” project was initiated by the business.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-influences.png" alt="Tone of Voice, Digital Magazine & Loyalty program examples of influence" style="width:100%;height:auto;">
						<figcaption>Tone of Voice, Digital Magazine & Loyalty program examples of influence</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Challenge</h2>

					<p>The goal of the project was to create a visual language that mirrors the Brown Thomas brand proposition. By creating a design system we would be able to develop a single underlying system that unifies the user experience across all omnichannel touchpoints. This would give a solid but flexible foundation on which to build and expand.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-atoms-sample.png" alt="Brown Thomas Design System - Atoms" style="width:100%;height:auto;">
						<figcaption>Brown Thomas Design System - Atoms</figcaption>
					</figure>

					<p>The design system was only one of the deliverables though and not one to stimulate the visual mind of the stakeholders who would ultimately sign off on the project. Each existing page, element & feature would be touched while new features would be conceptualised.</p>

					<p>The key goals of the project were:</p>

					<ul>
						<li>Increase engagement with content led shopping journeys.</li>
						<li>Be device friendly across mobile, tablet & desktop.</li>
						<li>To demonstrate authority and leadership in the Irish fashion & beauty industry.</li>
						<li>Improve metrics such as conversion, traffic & time on site.</li>
					</ul>

					<p>With such a large project, we partnered with Onstate, a design agency based in Leeds, England who had worked with the business on the digital magazine creation and were familiar with the new direction.</p>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>My Role</h2>

					<p>I was the UX lead on the project team consisting of a Business Analyst, Project Manager, Technical Analyst and the Head of Product while on the agency side we had 2 Designers, a Project Manager and the Co-founders of the agency. I would be the point of contact for all design & front-end matters and collaborated closely with the designers at Onstate to capture requirements, create low-res wireframes and communicate feedback from stakeholders.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-plp-wireframes.png" alt="Brown Thomas Redesign - Wireframes showing content integrated within the shopping journey" style="width:100%;height:auto;">
						<figcaption>Brown Thomas Redesign - Wireframes showing content integrated within the shopping journey</figcaption>
					</figure>

					<p>As part of the design process, I ran an almost daily briefing with stakeholders to present work in progress to ensure it was achieving the intended goals of the project and iterate quickly when needs be.</p>


					<p>Once business approval was given to the visual direction of the project, I was involved in a number of discovery workshops with the internal team, Onstate and our SFCC development partner, Astound Commerce. In these sessions the visual design, core templates and journeys were reviewed and evaluated so that all changes made are detailed in the form of a BRD and from which development estimations could be provided.</p>

					<p>In the development phase, I was responsible for creating the requirements to integrate the design system while also creating HTML/CSS prototypes to communicate the functionality of new features. I also assisted the QA team with approving releases and led the communication & education efforts with teams in the wider business to leverage the new features and design system.</p>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-prototype-example.png" alt="Brown Thomas Redesign - Screenshot of HTML/CSS content prototype" style="width:100%;height:auto;">
						<figcaption>Brown Thomas Redesign - Screenshot of HTML/CSS content prototype</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Results</h2>

					<p>Once the initial design phase had wrapped and the partnership with Onstate concluded, the project hit a number of roadblocks which ultimately resulted in a large descoping exercise. Sticking to the goals of the project, a number of key aspects would be developed in early 2019.</p>

					<h5>Design system - colours, typography, grid, iconography, illustrations</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-final-illustrations.png" alt="Completed design system elements & illustrations by Jo Bird." style="width:100%;height:auto;">
						<figcaption>Completed design system elements & illustrations by Jo Bird.</figcaption>
					</figure>

					<h5>Search suggestions enhancements</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-search-update.png" alt="Desktop and mobile screens showing search history enabled and more concise category & brand search suggestions." style="width:100%;height:auto;">
						<figcaption>Desktop and mobile screens showing search history enabled and more concise category & brand search suggestions.</figcaption>
					</figure>

					<h5>Stock, Loyalty & Share component for PDP</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-pdp-stock-indicators.png" alt="PDP design with stock indicators, loyalty messaging and share functionality" style="width:100%;height:auto;">
						<figcaption>PDP design with stock indicators, loyalty messaging and share functionality</figcaption>
					</figure>

					<h5>New mobile PLP filter functionality</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-plp-mobile-filters.png" alt="Mobile filters screens" style="width:100%;height:auto;">
						<figcaption>Mobile filters screens - previously page would reload with each filter applied, update put user in control with no sudden page refreshes.</figcaption>
					</figure>

					<h5>New PLP template</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-plp-update.png" alt="PLP template for desktop & mobile showing updateded content integration slots." style="width:100%;height:auto;">
						<figcaption>PLP template for desktop & mobile showing updateded content integration slots.</figcaption>
					</figure>

					<h5>New marketing content types</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-content-types.png" alt="Brown Thomas Redesign - Screenshot of HTML/CSS content prototype" style="width:100%;height:auto;">
						<figcaption>New content types - a masonry template type, horizontal content panel with light or dark display option, hero banner.</figcaption>
					</figure>

					<h5>New PLP SEO component</h5>

					<figure>
						<img class="lazyload" data-src="/images/bt-design-system-seo-slot.png" alt="SEO slot allowing for larger text blocks without pushing products below the fold." style="width:100%;height:auto;">
						<figcaption>SEO slot allowing for larger text blocks without pushing products too far below the fold.</figcaption>
					</figure>
				</div>
		    </section>

		    <section>
		        <div class="bd_article_container">
					<h2>The Takeaways</h2>

					<p>In this project I not only learned so much about design systems, I was also able to really practice and become comfortable presenting to and working with stakeholders of all levels and across departments. This taught me to also manage stakeholder engagement carefully. While I feel that on this project, the frequency of them could have been scaled back - a lot of focus and time can be lost discussing the colour of a button or revising already approved designs - I came out of this knowing how to refine my process and focus when engaging in the future.</p>

					<p>This was also my first large scale project and while maintaining a close and sound relationship with our design agency partner, communication and timelines were not without their challenges.</p>
				</div>
		    </section>
		</div>

		<div class="container">
			<section class="bd_mywork">
				<div class="bd_section_title">
					<h2>Related to this project</h2>
				</div>
				
				<ul class="bd_projects_list">
					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-design-system.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-ds-banner-1280x720.png">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-ds-banner-1280x720.png" alt="" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: Design System</h3>

									<p class="p_bold">Creating a single source of truth.</p>
								</div>
							</div>
						</a>
					</li>

					<li class="bd_project">
						<a class="bd_project_image_block" href="/mywork/arnotts-digital-rebrand.php">
							<picture>
								<!--[if IE 9]><video style="display: none;"><![endif]-->
				        		<!--<source type="image/webp" srcset="https://via.placeholder.com/640x360.webp">-->

				        		<source srcset="/images/arnotts-digital-rebrand-banner-1280x720.jpg">

								<!--[if IE 9]></video><![endif]-->
				        		<img src="/images/arnotts-digital-rebrand-banner-1280x720.jpg" alt="Arnotts Digital Rebrand" title="" class="bd_project_image">
							</picture>

							<div class="bd_project_text_block">
								<div class="bd_project_text">
									<h3>Arnotts: Digital Rebrand</h3>

									<p class="p_bold">And a human, working within fast paced environments of the</p>
								</div>
							</div>
						</a>
					</li>
				</ul>

				<div class="bd_btn_block">
					<a class="btn" href="/mywork/">See all my work</a>
				</div>
			</section>
		</div>
	</main>

	<?php include("../footer.php"); ?>
</body>
</html>